* Setting directory
clear
set more off
cd "C:\Users\Andrew\My publications\Top Incomes - Panel Data\"

* Setting up WIID data
use wiid2a.dta, clear
gen seq=_n
gen temp=strpos(incdefn,"Income")
keep if temp~=0 & temp~=.
replace temp=strpos(incsharu,"Tax")
keep if temp==0
keep if areacov=="All" & popcovr=="All" & gini~=.
tab quality
sort country year quality seq
gen n=_n
bysort country year: egen n_cy=min(n)
keep if n==n_cy
keep gini country year
replace gini=gini/100
for any "New Zealand" "United Kingdom" "United States" \ any nz uk us: replace country="Y" if country=="X" 
replace country="Germany" if country=="Germany, West" & year<=1989
replace country=lower(country)
ren country cty
ren gini gini_wiid
sort cty year
save temp_topinc_wiid.dta, replace

use topinc_unadjusted, clear
ren taxyear year
drop splittaxyear
* Adjusting UK before 1990
tsset year
for var uk*: gen temp=X/l.X if year==1990 \ egen adj_X=max(temp) \ drop temp \ replace X=X*adj_X if year<=1989
sum adj* 
drop adj*
* Interpolating missing values
tsset year
for var aust* canad* ger* ire* jap* neth* nz* spa* swe* switz* spai* uk* us*: gen lag5=1 if X==. & l.X==. & l2.X==. & l3.X==. & l4.X==. \ replace lag5=1 if f.lag5==1 | f2.lag5==1 | f3.lag5==1 | f4.lag5==1 \ ipolate X year if lag5~=1, gen(temp) \ replace X=temp \ drop temp lag
sort year
save topinc_adj_taxyr, replace

* Shifting to a calendar year basis
tsset year
for var australia*: gen temp=(l.X+X)/2 \ replace X=temp \ drop temp
for var ireland*: gen temp=(l.X*0.25)+(X*0.75) \ replace X=temp \ drop temp
for var nz*: gen temp=(l.X*0.25)+(X*0.75) \ replace X=temp \ drop temp 
for var uk*: gen temp=(l.X*0.25)+(X*0.75) \ replace X=temp \ drop temp 
sort year
save topinc_adj_calyr, replace

drop *001 *005 *01 *05 *5 
order year australia10 canada10 france10 germany10 ireland10 netherlands10 nz10 spain10 sweden10 switzerland10 uk10 us10
sort year
save topinc_adj_calyr_1_10, replace

/*
* Graphing the top 10% and 1% series
set scheme s2mono
* NB. No Japan 10% series
for any australia canada france germany ireland netherlands nz spain sweden switzerland uk us \ any Australia Canada France Germany Ireland Netherlands "New Zealand" Spain Sweden Switzerland UK US: la var X10 "Y"
for any australia canada france germany ireland japan netherlands nz spain sweden switzerland uk us \ any Australia Canada France Germany Ireland Japan Netherlands "New Zealand" Spain Sweden Switzerland UK US: la var X1 "Y" 
twoway connected australia10 canada10 ireland10 nz10 uk10 us10 year if year>1900, ti("Fig 1: Income Share of Richest 10%" "in Anglo-Saxon Countries") ylabel(20(5)55)
twoway connected france10 germany10 netherlands10 spain10 sweden10 switzerland10 year if year>1900, ti("Fig 2: Income Share of Richest 10%" "in Non Anglo-Saxon Countries") ylabel(20(5)55)
twoway connected australia1 canada1 ireland1 nz1 uk1 us1 year if year>1900, ti("Fig 3: Income Share of Richest 1%" "in Anglo-Saxon Countries") ylabel(5(5)30)
twoway connected france1 germany1 japan1 netherlands1 spain1 sweden1 switzerland1 year if year>1900, ti("Fig 4: Income Share of Richest 1%" "in Non Anglo-Saxon Countries") ylabel(5(5)30)
*/

* NB. No Japan 10% series
gen japan10=.
for any australia canada france germany ireland japan netherlands nz spain sweden switzerland uk us: ren X10 share10X \ ren X1 share1X
keep share* year 
reshape long share1 share10, i(year) j(cty) string
gen ctyno=.
for any australia canada france germany ireland japan netherlands nz spain sweden switzerland uk us \ num 1/13: replace ctyno=Y if cty=="X"

for any lis : sort cty year \ merge cty year using X_inequality,nokeep \ drop _merge \ ren gini gini_X
sort cty year
merge cty year using temp_topinc_wiid.dta, nokeep
drop _merge

for var gini* atkinson*: replace X=X*100
gen _5010=_9010/_9050
for any 9010 9050 5010 \ any "90:10" "90:50" "50:10": la var _X "Y"
* Summary statistics (Appendix Table 2)
sum share10 share1 gini_wiid gini_lis atkinson1 _9010  _5010 _9050 if share10~=. | share1~=.,sep(0)
bysort cty: egen minyear=min(year) if share1~=. | share10~=.
bysort cty: egen maxyear=max(year) if share1~=. | share10~=.
tabstat minyear maxyear, by(cty)
drop minyear maxyear
* Pairwise correlations
pwcorr share10 share1 gini_wiid gini_lis atkinson1 _9010 _5010 _9050 if share10~=. | share1~=.,sig
pwcorr share10 share1 gini_wiid gini_lis atkinson1 _9010 _5010 _9050 if share10~=. | share1~=.
for var gini* atkinson* _5010 _9010 _9050: replace X=ln(X)
gen lnshare10=ln(share10)
gen lnshare1=ln(share1)

* How closely do the measures of inequality vary with top income shares? 
* Top 10% Share
for any gini_lis: reg lnshare10 X , r \ outreg using table1.doc, coefastr nocons bracket 3aster replace bdec(3) se ti("Top 10% share and LIS Inequality measures") ct("10% - X")
tab cty if e(sample)
for any atkinson1 _9010 _9050 _5010: reg lnshare10 X , r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X") 
for any 10: reg lnshareX _9050 _5010 , r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X") 
for any gini_lis atkinson1 _9010 _9050 _5010: xi: areg lnshare10 X , r a(ctyno) \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C FE") 
for num 10: xi: reg lnshareX _9050 _5010 i.ctyno, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C FE") 
for any gini_lis atkinson1 _9010 _9050 _5010: xi: areg lnshare10 X i.year, r a(ctyno) \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C&Y FE") 
for num 10: xi: reg lnshareX _9050 _5010 i.ctyno i.year, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C&Y FE") 
* Top 1% Share
for any gini_lis atkinson1 _9010 _9050 _5010: reg lnshare1 X , r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("1% - X") 
for any 1: reg lnshareX _9050 _5010 , r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X") 
for any gini_lis atkinson1 _9010 _9050 _5010: xi: reg lnshare1 X i.ctyno, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C FE") 
for num 1: xi: reg lnshareX _9050 _5010 i.ctyno, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C FE") 
for any gini_lis atkinson1 _9010 _9050 _5010: xi: reg lnshare1 X i.year i.ctyno, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C&Y FE") 
for num 1: xi: reg lnshareX _9050 _5010 i.year i.ctyno, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C&Y FE") 
* Now WIID ginis
for any gini_wiid: reg lnshare10 X , r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X") 
for any gini_wiid: xi: reg lnshare10 X i.ctyno, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C FE") 
for any gini_wiid: xi: reg lnshare10 X i.year i.ctyno, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C&Y FE") 
for any gini_wiid: reg lnshare1 X , r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X") 
for any gini_wiid: xi: reg lnshare1 X i.ctyno, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C FE") 
for any gini_wiid: xi: reg lnshare1 X i.year i.ctyno, r \ outreg using table1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X C&Y FE") 
tab cty if e(sample)
